package it.inaf.oats.vospace;

import javax.servlet.http.HttpServletRequest;
import static org.junit.jupiter.api.Assertions.assertTrue;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import static org.mockito.Mockito.when;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.test.web.servlet.MockMvc;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.get;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;

@ExtendWith(MockitoExtension.class)
public class CapabilitiesControllerTest {

    private MockMvc mockMvc;

    @Mock
    private HttpServletRequest request;

    @InjectMocks
    private CapabilitiesController controller;

    @BeforeEach
    public void init() {
        mockMvc = MockMvcBuilders.standaloneSetup(controller).build();
    }

    @Test
    public void testGetCapabilitiesBase() throws Exception {

        when(request.getServerName()).thenReturn("ia2.inaf.it");
        when(request.getServerPort()).thenReturn(8080);
        when(request.getContextPath()).thenReturn("/vospace");
        when(request.getScheme()).thenReturn("http");

        String xml = mockMvc.perform(get("/capabilities"))
                .andExpect(status().isOk())
                .andReturn().getResponse().getContentAsString();

        assertTrue(xml.contains("http://ia2.inaf.it:8080/vospace/nodes"));
    }

    @Test
    public void testGetCapabilitiesProxied() throws Exception {

        when(request.getHeader("X-Forwarded-Proto")).thenReturn("https");
        when(request.getHeader("X-Forwarded-Host")).thenReturn("ia2.inaf.it,server2.ia2.inaf.it");

        when(request.getContextPath()).thenReturn("/vospace");

        String xml = mockMvc.perform(get("/capabilities"))
                .andExpect(status().isOk())
                .andReturn().getResponse().getContentAsString();

        assertTrue(xml.contains("https://ia2.inaf.it/vospace/nodes"));
    }
}
