package it.inaf.oats.vospace;

import it.inaf.oats.vospace.persistence.NodeDAO;
import java.util.ArrayList;
import java.util.List;
import net.ivoa.xml.uws.v1.JobSummary;
import net.ivoa.xml.uws.v1.ResultReference;
import net.ivoa.xml.vospace.v2.Node;
import net.ivoa.xml.vospace.v2.Transfer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UriService {

    @Value("${vospace-authority}")
    private String authority;

    @Value("${file-service-url}")
    private String fileServiceUrl;

    @Autowired
    private NodeDAO nodeDao;

    public void setTransferJobResult(JobSummary job) {

        List<ResultReference> results = new ArrayList<>();

        ResultReference result = new ResultReference();
        result.setHref(getUri(job));
        results.add(result);

        job.setResults(results);
    }

    private String getUri(JobSummary job) {

        // TODO add checks on data type
        Transfer transfer = (Transfer) job.getJobInfo().getAny().get(0);

        String relativePath = transfer.getTarget().substring("vos://".length() + authority.length());

        // TODO handle node not found
        Node node = nodeDao.listNode(relativePath).get();

        // TODO build the path according to node type
        //
        // TODO add token for authenticated access
        return fileServiceUrl + relativePath + "?jobId=" + job.getJobId();
    }
}
