package it.inaf.oats.vospace;

import it.inaf.ia2.aa.TokenFilter;
import it.inaf.ia2.aa.data.User;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.springframework.boot.test.context.TestConfiguration;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;

@TestConfiguration
public class TokenFilterConfig {

    @Bean
    @Primary
    public FilterRegistrationBean tokenFilterRegistration() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter(new FakeTokenFilter());
        registration.addUrlPatterns("/*");
        return registration;
    }

    private static class FakeTokenFilter extends TokenFilter {

        @Override
        public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {

            HttpServletRequest request = (HttpServletRequest) req;
            HttpServletResponse response = (HttpServletResponse) res;

            String authHeader = request.getHeader("Authorization");

            if (authHeader != null) {
                if (authHeader.startsWith("Bearer ")) {
                    String token = authHeader.substring("Bearer ".length());
                    HttpServletRequestWrapper requestWithPrincipal = new RequestWithPrincipal(request, getFakeUser(token));
                    chain.doFilter(requestWithPrincipal, response);
                    return;
                }
            }

            chain.doFilter(getAnonymousServletRequest(request), response);
        }

        private User getFakeUser(String token) {

            User user = new User();

            switch (token) {
                case "user1_token":
                    user.setUserId("user1").setUserLabel("User1");
                    break;
                case "user2_token":
                    user.setUserId("user2").setUserLabel("User2").setGroups(Arrays.asList("group1", "group2"));
                    break;
                default:
                    throw new IllegalArgumentException("Fake user not configured for token " + token);
            }

            user.setAccessToken(token);

            return user;
        }

        private static HttpServletRequestWrapper getAnonymousServletRequest(HttpServletRequest request) {
            User anonymousUser = new User()
                    .setUserId("anonymous")
                    .setUserLabel("Anonymous")
                    .setGroups(new ArrayList<>());
            return new RequestWithPrincipal(request, anonymousUser);
        }

        private static class RequestWithPrincipal extends HttpServletRequestWrapper {

            private final User user;

            public RequestWithPrincipal(HttpServletRequest request, User user) {
                super(request);
                this.user = user;
            }

            @Override
            public Principal getUserPrincipal() {
                return user;
            }
        }
    }
}
