/*
 * This file is part of vospace-rest
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
package it.inaf.oats.vospace.persistence.model;

public enum StorageType {

    COLD("cold"),
    HOT("hot"),
    LOCAL("local");

    private final String name;

    private StorageType(String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        return name;
    }

    public static StorageType parse(String value) {
        for (StorageType type : StorageType.values()) {
            if (type.name.equals(value)) {
                return type;
            }
        }
        throw new IllegalArgumentException("Invalid StorageType " + value);
    }
}
