/*
 * This file is part of vospace-rest
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
package it.inaf.oats.vospace.exception;

import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ResponseStatus;

@ResponseStatus(value = HttpStatus.INTERNAL_SERVER_ERROR)
public abstract class VoSpaceErrorSummarizableException extends VoSpaceException {
    
    VOSpaceFaultEnum fault;
    private String detailMessage;
    
    public VoSpaceErrorSummarizableException(String detailMessage, VOSpaceFaultEnum fault)
    {
        super(fault.getFaultCaptionForDetails() + " " + detailMessage);
        this.detailMessage = detailMessage;
        this.fault = fault;        
    }
        
    public VOSpaceFaultEnum getFault()
    {
        return this.fault;
    }
        
    public String getDetailMessage()
    {
        return this.detailMessage;
    }
}
