package it.inaf.oats.vospace.exception;

import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ResponseStatus;

@ResponseStatus(value = HttpStatus.BAD_REQUEST)
public class InvalidURIException extends VoSpaceException {

    public InvalidURIException(String URI, String path) {
        super("InvalidURI. Payload node URI: " + URI
                + " is not consistent with request path: " + path);
    }

    public InvalidURIException(String URI) {
        super("InvalidURI. URI: " + URI + " is not in a valid format");
    }

    public InvalidURIException(IllegalArgumentException ex) {
        super("InvalidURI. " + ex.getMessage());
    }
}
