/*
 * This file is part of vospace-rest
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
package it.inaf.oats.vospace;

import it.inaf.oats.vospace.datamodel.NodeUtils;
import it.inaf.oats.vospace.exception.InvalidURIException;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseNodeController {

    @Autowired
    private HttpServletRequest servletRequest;

    protected String getPath() {
        // This is to allow calls from the code to CreateNodeController
        // since request url is not set
        if(servletRequest.getRequestURL() == null)
            return null;
        
        String requestURL = servletRequest.getRequestURL().toString();
        try {
            return NodeUtils.getPathFromRequestURLString(requestURL);
        } catch (IllegalArgumentException ex) {
            throw new InvalidURIException(ex);
        }
    }

    protected String getParentPath(String path) {
        return NodeUtils.getParentPath(path);
    }
}
