/*
 * This file is part of vospace-rest
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
package it.inaf.oats.vospace.exception;

import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ResponseStatus;

@ResponseStatus(value = HttpStatus.BAD_REQUEST)
public class InvalidURIException extends VoSpaceErrorSummarizableException {

    public InvalidURIException(String URI, String path) {
        super("Payload node URI: " + URI
                + " is not consistent with request path: " + path,
                VOSpaceFaultEnum.INVALID_URI);
    }

    public InvalidURIException(String URI) {
        super("URI: " + URI + " is not in a valid format",
                VOSpaceFaultEnum.INVALID_URI);
    }

    public InvalidURIException(IllegalArgumentException ex) {
        super("Description: " + ex.getMessage(),
                VOSpaceFaultEnum.INVALID_URI);
    }
}
