package it.inaf.oats.vospace;

import it.inaf.oats.vospace.persistence.NodeDAO;
import java.util.Optional;
import net.ivoa.xml.uws.v1.JobSummary;
import net.ivoa.xml.vospace.v2.DataNode;
import net.ivoa.xml.vospace.v2.Node;
import net.ivoa.xml.vospace.v2.Transfer;
import static org.junit.jupiter.api.Assertions.assertEquals;
import org.junit.jupiter.api.Test;
import static org.mockito.ArgumentMatchers.eq;
import static org.mockito.Mockito.when;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.test.context.TestPropertySource;

@SpringBootTest
@AutoConfigureMockMvc
@TestPropertySource(properties = {"vospace-authority=example.com!vospace", "file-service-url=http://file-service"})
public class UriServiceTest {

    @MockBean
    private NodeDAO dao;

    @Autowired
    private UriService transferService;

    @Test
    public void testSimpleUrl() {

        Node node = new DataNode();

        when(dao.listNode(eq("/mydata1"))).thenReturn(Optional.of(node));

        Transfer transfer = new Transfer();
        transfer.setTarget("vos://example.com!vospace/mydata1");

        JobSummary job = new JobSummary();
        job.setJobId("job-id");

        JobSummary.JobInfo jobInfo = new JobSummary.JobInfo();
        jobInfo.getAny().add(transfer);

        job.setJobInfo(jobInfo);

        transferService.setTransferJobResult(job);

        assertEquals("http://file-service/mydata1?jobId=job-id", job.getResults().get(0).getHref());
    }
}
