/*
 * This file is part of vospace-rest
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
package it.inaf.oats.vospace;

import it.inaf.ia2.aa.data.User;
import it.inaf.oats.vospace.datamodel.collections.NodeCollectionsWrapper;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

/**
 *
 * @author Nicola Fulvio Calabria <nicola.calabria at inaf.it>
 */
@RestController
public class CollectionsController {

    private static final Logger LOG = LoggerFactory.getLogger(CollectionsController.class);

    @Autowired
    private CollectionsService collectionsService;

    // list collections owned by user
    @GetMapping(value = "/collections")
    public ResponseEntity<NodeCollectionsWrapper> listCollections(
            HttpServletRequest request, User principal) {
        LOG.debug("list collections called for user {}", principal.getName());

        NodeCollectionsWrapper ncl = new NodeCollectionsWrapper();

        ncl.setNodeCollections(
                collectionsService.listCollections(principal.getName()));

        return ResponseEntity.ok(ncl);
    }

    // create a new collection with specified title
    @PutMapping(value = "/collections")
    public ResponseEntity<String> createCollection(
            @RequestBody String collectionName, User principal) {
        LOG.debug("create collection called with name {} called for user {}", 
                collectionName, principal.getName());       

        collectionsService.createNewCollection(collectionName, principal.getName());

        return ResponseEntity.ok("Collection created");
    }

    // delete collection by id
    @DeleteMapping(value = "/collections")
    public ResponseEntity<String> deleteCollection(
            @RequestBody Long collectionId, User principal) {
        LOG.debug("delete collection called with id {} for user {}", 
                collectionId, principal.getName());
        
        collectionsService.deleteCollectionById(collectionId, principal.getName());
        
        return ResponseEntity.ok("Collection deleted");
                
    }
    
}
