package it.inaf.oats.vospace.exception;

import net.ivoa.xml.uws.v1.ErrorSummaryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ResponseStatus;

@ResponseStatus(value = HttpStatus.INTERNAL_SERVER_ERROR)   // Status code 500
public class InternalFaultException extends VoSpaceErrorSummarizableException {

    private static final Logger LOG = LoggerFactory.getLogger(InternalFaultException.class);

    public InternalFaultException(String msg) {
        super("InternalFaultException: " + msg,
                ErrorSummaryFactory.VOSpaceFault.INTERNAL_FAULT);
    }

    public InternalFaultException(Throwable cause) {
        super("InternalFaultException: " + getMessage(cause),
                ErrorSummaryFactory.VOSpaceFault.INTERNAL_FAULT);
    }

    private static String getMessage(Throwable cause) {
        LOG.error("Exception caught", cause);
        return cause.getMessage() != null ? cause.getMessage() : cause.getClass().getCanonicalName();
    }
}
