package it.inaf.oats.vospace.exception;

import net.ivoa.xml.uws.v1.ErrorSummaryFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ResponseStatus;

@ResponseStatus(value = HttpStatus.BAD_REQUEST)
public class LinkFoundException extends VoSpaceErrorSummarizableException {

    public LinkFoundException(String path) {
        super("Link Found at path: " + path, 
                ErrorSummaryFactory.VOSpaceFault.INVALID_URI);
    }
}
