package it.inaf.oats.vospace.persistence.model;

public enum StorageType {

    COLD("cold"),
    HOT("hot"),
    LOCAL("local"),
    PORTAL("portal");

    private final String name;

    private StorageType(String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        return name;
    }

    public static StorageType parse(String value) {
        for (StorageType type : StorageType.values()) {
            if (type.name.equals(value)) {
                return type;
            }
        }
        throw new IllegalArgumentException("Invalid StorageType " + value);
    }
}
