package it.inaf.oats.vospace;

import it.inaf.oats.vospace.exception.NodeNotFoundException;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.http.ResponseEntity;

import net.ivoa.xml.vospace.v2.Node;
import net.ivoa.xml.vospace.v2.ContainerNode;

import it.inaf.oats.vospace.persistence.NodeDAO;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import it.inaf.ia2.aa.data.User;
import it.inaf.oats.vospace.datamodel.NodeUtils;
import java.util.Optional;
import it.inaf.oats.vospace.exception.PermissionDeniedException;
import java.util.stream.Collectors;
import java.util.List;

@RestController
public class ListNodeController extends BaseNodeController {

    private static final Logger LOG = LoggerFactory.getLogger(ListNodeController.class);

    @Autowired
    private NodeDAO nodeDAO;

    @GetMapping(value = {"/nodes", "/nodes/**"},
            produces = {MediaType.APPLICATION_XML_VALUE, MediaType.APPLICATION_JSON_VALUE, MediaType.TEXT_XML_VALUE})
    public ResponseEntity<Node> listNode(HttpServletRequest request, User principal) {
        String path = getPath();
        LOG.debug("listNode called for path {}", path);

        Optional<Node> optNode = nodeDAO.listNode(path);

        if (optNode.isEmpty()) {
            throw new NodeNotFoundException(path);
        } else {
            if (!NodeUtils.checkIfReadable(
                    optNode.get(), principal.getName(), principal.getGroups())) {
                throw new PermissionDeniedException(path);
            }
        }
        
        Node node = optNode.get();

        if (node instanceof ContainerNode) {
            ContainerNode cnd = (ContainerNode) node;
            List<Node> children
                    = cnd.getNodes().stream().filter(
                            (n) -> NodeUtils.checkIfReadable(
                                    n, principal.getName(),
                                    principal.getGroups()))
                            .collect(Collectors.toList());
            cnd.setNodes(children);
            optNode = Optional.of(cnd);
        }

        return ResponseEntity.ok(optNode.get());

    }
}
