package it.inaf.oats.vospace.persistence.model;

public enum LocationType {

    ASYNC("async"),
    PORTAL("portal"),
    USER("user");

    private final String name;

    private LocationType(String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        return name;
    }

    public static LocationType parse(String value) {
        for (LocationType type : LocationType.values()) {
            if (type.name.equals(value)) {
                return type;
            }
        }
        throw new IllegalArgumentException("Invalid LocationType " + value);
    }
}
