/*
 * This file is part of vospace-rest
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
package it.inaf.oats.vospace;

import it.inaf.ia2.aa.data.User;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class DeleteNodeController extends BaseNodeController {

    @Autowired
    DeleteNodeService deleteNodeService;

    private static final Logger LOG = LoggerFactory.getLogger(DeleteNodeController.class);

    @DeleteMapping(value = {"/nodes", "/nodes/**"},
            produces = {MediaType.APPLICATION_XML_VALUE, MediaType.TEXT_XML_VALUE, MediaType.APPLICATION_JSON_VALUE})
    public ResponseEntity<String> deleteNode(HttpServletRequest request, User principal) {

        String path = getPath();
        LOG.debug("deleteNode called for path {}", path);

        deleteNodeService.doPreliminaryChecks(path);
        deleteNodeService.deleteNode(path, principal);
        return ResponseEntity.ok("Node deleted");

    }

}
