package it.inaf.oats.vospace;

import it.inaf.oats.vospace.persistence.JobDAO;
import net.ivoa.xml.uws.v1.ExecutionPhase;
import net.ivoa.xml.uws.v1.JobSummary;
import net.ivoa.xml.vospace.v2.Transfer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JobService {

    @Autowired
    private JobDAO jobDAO;

    @Autowired
    private UriService uriService;

    @Autowired
    private TapeService tapeService;

    enum JobType {
        pullToVoSpace,
        pullFromVoSpace,
        moveNode,
        copyNode
    }

    public void setJobPhase(JobSummary job, String phase) {

        // TODO: check allowed job phase transitions
        switch (phase) {
            case "RUN":
                startJob(job);
                break;
            case "ABORT":
                throw new UnsupportedOperationException("Not implemented yet");
            default:
                throw new IllegalArgumentException("Invalid phase parameter: " + phase);
        }
    }

    private void startJob(JobSummary job) {

        switch (getJobType(job)) {
            case pullToVoSpace:
                handlePullToVoSpace(job);
                break;
            case pullFromVoSpace:
                handlePullFromVoSpace(job);
                break;
            default:
                throw new UnsupportedOperationException("Not implemented yet");
        }
    }

    private void handlePullToVoSpace(JobSummary job) {
        // TODO: check protocol
        tapeService.startJob(job);
    }

    private void handlePullFromVoSpace(JobSummary job) {
        job.setPhase(ExecutionPhase.EXECUTING);
        uriService.setTransferJobResult(job);
        jobDAO.updateJob(job);
    }

    private JobType getJobType(JobSummary job) {

        // TODO: check types
        Transfer transfer = (Transfer) job.getJobInfo().getAny().get(0);

        return JobType.valueOf(transfer.getDirection());
    }

    /**
     * Synchronous transfer endpoint creates a job that is immediately set to
     * completed.
     */
    public void createSyncJobResult(JobSummary job) {
        job.setPhase(ExecutionPhase.COMPLETED);
        uriService.setSyncTransferEndpoints(job);
        jobDAO.createJob(job);
    }
}
