/* 
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
/**
 * Author:  bertocco
 * Created: Sep 17, 2020
 */

CREATE EXTENSION IF NOT EXISTS ltree;

CREATE TABLE node (
  id                BIGSERIAL       PRIMARY KEY,
  ivo_id            text            NOT NULL,
  name              text            NOT NULL,
  type              text            NOT NULL,
  format            text            NOT NULL,
/* format e` per distinguere unstuctured (format=NULL da structured che hanno 
un formato noto)
*/
  asyncTrans        boolean         NOT NULL, 
/* asyncTransf serve per indicare se il nodo e` ospitato da un cold storage e 
deve essere necessariamente trasferito con un trasferimento asincrono */
  busyState         CHAR(1)         NOT NULL,
  ownerID           INT             NOT NULL,
  creatorID         INT             NOT NULL,
  groupRead         text            default NULL,
  groupWrite        text            default NULL,
  isPublic          CHAR(1)         NOT NULL default 'Y',
  delta             BIGINT          default NULL,
/* potrebbe essere un delta di dati trasferito durante un trasferimento asincrono.
Dovrebbe stare sul servizio che fa il trasferimento  (es. redis) */
  contentType       VARCHAR(100)    default NULL,
  contentEncoding   VARCHAR(50)     default NULL,
  contentLength     BIGINT          default NULL,
  contentMD5        VARCHAR(256)    default NULL,
  creationDate      timestamp       NOT NULL DEFAULT NOW(),
  lastModification  timestamp       NOT NULL DEFAULT NOW(),
  /*
  link             TEXT          default NULL,
  */  
  acceptViews      TEXT[],
  provideViews     TEXT[], 
  /*
   storageID       VARCHAR(256),
   serve per mappare il nome del servizio di storage da interrogare per accedere al contenuto di questo nodo */
  protocols       TEXT[],

  path            ltree             NOT NULL
  /*
  is_leaf boolean,
  */

  CONSTRAINT ivo_id_unique UNIQUE (ivo_id)

);




