package it.inaf.oats.vospace.persistence;

import javax.sql.DataSource;
import net.ivoa.xml.vospace.v2.ContainerNode;
import net.ivoa.xml.vospace.v2.Node;
import net.ivoa.xml.vospace.v2.Property;
import static org.junit.jupiter.api.Assertions.assertEquals;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(SpringExtension.class)
@ContextConfiguration(classes = {DataSourceConfig.class})
@TestPropertySource(locations = "classpath:test.properties")
public class NodeDAOTest {

    @Autowired
    private DataSource dataSource;
    private NodeDAO dao;

    @BeforeEach
    public void init() {
        dao = new NodeDAO(dataSource);
    }

    @Test
    public void testListNode() {
        ContainerNode root = (ContainerNode) dao.listNode("/").get();
        assertEquals(2, root.getNodes().size());

        assertEquals("group1 group2", getProperty(root.getNodes().get(0), "ivo://ivoa.net/vospace/core#groupread"));
    }

    private String getProperty(Node node, String uri) {
        for (Property property : node.getProperties()) {
            if (uri.equals(property.getUri())) {
                return property.getValue();
            }
        }
        return null;
    }
}
