package it.inaf.oats.vospace;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.UncheckedIOException;
import net.ivoa.xml.uws.v1.JobSummary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TapeService {

    private static final Logger LOG = LoggerFactory.getLogger(TapeService.class);

    @Autowired
    private RabbitTemplate template;

    private static final ObjectMapper MAPPER = new ObjectMapper();

    public JobSummary startJob(JobSummary job) {
        try {
            byte[] message = MAPPER.writeValueAsBytes(job);
            byte[] result = (byte[]) template.convertSendAndReceive("start_job_queue", message);

            LOG.trace("Tape transfer service answered:\n{}", new String(result));

            return MAPPER.readValue(result, JobSummary.class);
        } catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }
}
