package it.inaf.oats.vospace;

import static it.inaf.oats.vospace.CreateNodeControllerTest.getResourceFileContent;
import it.inaf.oats.vospace.persistence.NodeDAO;
import java.util.Optional;
import net.ivoa.xml.vospace.v2.ContainerNode;
import net.ivoa.xml.vospace.v2.DataNode;
import net.ivoa.xml.vospace.v2.Node;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.boot.test.mock.mockito.SpyBean;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.web.servlet.MockMvc;
import org.junit.jupiter.api.Test;
import static org.mockito.ArgumentMatchers.eq;
import static org.mockito.Mockito.when;
import org.springframework.http.MediaType;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.put;
import static org.springframework.test.web.servlet.result.MockMvcResultHandlers.print;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

@SpringBootTest
@ContextConfiguration(classes = {TokenFilterConfig.class})
@TestPropertySource(properties = "spring.main.allow-bean-definition-overriding=true")
@AutoConfigureMockMvc 
public class DeleteNodeControllerTest {    
    
    private static final String URI_PREFIX = "vos://example.com!vospace";
    
    @MockBean
    private NodeDAO nodeDao;

    @SpyBean
    @Autowired
    private DeleteNodeController controller;

    @Autowired
    private MockMvc mockMvc;


    @Test
    public void testDeleteRootNode() throws Exception {
        
        when(nodeDao.listNode(eq("/"))).thenReturn(getRootNode());

        mockMvc.perform(MockMvcRequestBuilders
                        .delete("/nodes")
                        .header("Authorization", "Bearer user2_token"))
                        .andExpect(status().isForbidden());
        /*
        mockMvc.perform(delete("/members/1").
                .header("Authorization", "Bearer user2_token"))
                .andExpect(status().isNotFound());
        mockMvc.perform(delete("/")
                .header("Authorization", "Bearer user2_token"))
                .andExpect(status().isNotFound());
        */
    }
    

    @Test
    public void testNodeNotFound() throws Exception {
        
        when(nodeDao.listNode(eq("/mynode"))).thenReturn(Optional.of(getDataNode()));
        
        mockMvc.perform(MockMvcRequestBuilders
                        .delete("/nodes/mynode")
                        .header("Authorization", "Bearer user2_token"))
                        .andExpect(status().isOk());
        /*
        mockMvc.perform(delete("/members/1").
                .header("Authorization", "Bearer user2_token"))
                .andExpect(status().isNotFound());
        mockMvc.perform(delete("/")
                .header("Authorization", "Bearer user2_token"))
                .andExpect(status().isNotFound());
        */
    }
    /*
    @Test
    public void testDeleteRoot1() throws Exception {
        
        mockMvc.perform(put("/nodes/mydata1")
                .header("Authorization", "Bearer user2_token"))
                //.content(requestBody)
                //.contentType(MediaType.APPLICATION_JSON)
                //.accept(MediaType.APPLICATION_XML))
                //.andDo(print())
                .andExpect(status().isOk());

     
    }
    
    

    @Test
    public void testDeleteRoot2() throws Exception {
        
        mockMvc.perform(put("/nodes/mydata1")
                .header("Authorization", "Bearer user2_token"))
                //.content(requestBody)
                //.contentType(MediaType.APPLICATION_JSON)
                //.accept(MediaType.APPLICATION_XML))
                //.andDo(print())
                .andExpect(status().isOk());

     
    }
    

    @Test
    public void testDeleteExistingNodeInRoot() throws Exception {
        
        mockMvc.perform(put("/nodes/mydata1")
                .header("Authorization", "Bearer user2_token"))
                //.content(requestBody)
                //.contentType(MediaType.APPLICATION_JSON)
                //.accept(MediaType.APPLICATION_XML))
                //.andDo(print())
                .andExpect(status().isOk());

     
    }
    

    @Test
    public void testDeleteExistingNodeLeaf() throws Exception {
        
        mockMvc.perform(put("/nodes/mydata1")
                .header("Authorization", "Bearer user2_token"))
                //.content(requestBody)
                //.contentType(MediaType.APPLICATION_JSON)
                //.accept(MediaType.APPLICATION_XML))
                //.andDo(print())
                .andExpect(status().isOk());

     
    }
    

    @Test
    public void testDeleteExistingDataLinkInRoot() throws Exception {
        
        mockMvc.perform(put("/nodes/mydata1")
                .header("Authorization", "Bearer user2_token"))
                //.content(requestBody)
                //.contentType(MediaType.APPLICATION_JSON)
                //.accept(MediaType.APPLICATION_XML))
                //.andDo(print())
                .andExpect(status().isOk());

     
    }
    

    @Test
    public void testDeleteExistingDataLinkLeaf() throws Exception {
        
        mockMvc.perform(put("/nodes/mydata1")
                .header("Authorization", "Bearer user2_token"))
                //.content(requestBody)
                //.contentType(MediaType.APPLICATION_JSON)
                //.accept(MediaType.APPLICATION_XML))
                //.andDo(print())
                .andExpect(status().isOk());

     
    }
    

    @Test
    public void testDeleteExistingNodeWithDataLinkInPath() throws Exception {
        
        mockMvc.perform(put("/nodes/mydata1")
                .header("Authorization", "Bearer user2_token"))
                //.content(requestBody)
                //.contentType(MediaType.APPLICATION_JSON)
                //.accept(MediaType.APPLICATION_XML))
                //.andDo(print())
                .andExpect(status().isOk());

     
    }
*/    
    
    

    private Optional<Node> getRootNode() {
        ContainerNode root = new ContainerNode();
        root.setUri(URI_PREFIX + "/");
        root.getNodes().add(getDataNode());
        return Optional.of(root);
    }
    
    

    private Node getDataNode() {
        DataNode node = new DataNode();
        node.setUri(URI_PREFIX + "/mynode");
        return node;
    }
    
}
