/*
 * This file is part of vospace-rest
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
package it.inaf.oats.vospace.persistence;

import it.inaf.oats.vospace.datamodel.collections.NodeCollection;
import java.util.List;
import javax.sql.DataSource;
import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertTrue;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit.jupiter.SpringExtension;
import org.springframework.beans.factory.annotation.Autowired;

/**
 *
 * @author Nicola Fulvio Calabria <nicola.calabria at inaf.it>
 */

@ExtendWith(SpringExtension.class)
@ContextConfiguration(classes = {DataSourceConfig.class})
@TestPropertySource(locations = "classpath:test.properties")
public class CollectionsDAOTest {
        
    private CollectionsDAO collectionsDAO;
    
    @Autowired
    private DataSource dataSource;
    
    @BeforeEach
    public void init(){
        collectionsDAO = new CollectionsDAO(dataSource);        
    }
    
    @Test
    public void testInsertAndDeleteCollection() {
        assertTrue(collectionsDAO.getUserNodeCollections("pippo").isEmpty());
        
        collectionsDAO.createNewCollection("collection1", "pippo");
        collectionsDAO.createNewCollection("collection2", "pippo");
        
        List<NodeCollection> ncl = 
                collectionsDAO.getUserNodeCollections("pippo");
        
        assertEquals(2, ncl.size());
        
        for(NodeCollection nc : ncl) {
            collectionsDAO.deleteCollection(
                    nc.getId(), "pippo"
            );            
        }
        
        assertTrue(collectionsDAO.getUserNodeCollections("pippo").isEmpty());        
    }
        
    
}
