# VOSpace REST service

## Database

This VOSpace implementation uses the database populated by the [VOSpace Transfer Service application](https://www.ict.inaf.it/gitlab/ia2/vospace-transfer-service). The structure of the database is defined in a [separate repository](https://www.ict.inaf.it/gitlab/ia2/vospace-file-catalog). To avoid duplicating database definitions, DAO test classes load the database directly from the files of that repository. We assume that when running the tests the git repository exists and it is located in the same parent folder containing this repository.

To reconfigure the path of that repository edit the property `init_database_scripts_path` in test.properties.

## Loading fake users in MockMvc

Test classes annotated with `@SpringBootTest` and `@AutoConfigureMockMvc` can be used to test REST controllers. Theoretically it should be possible configure a fake principal to each test request using the following notation:

```java
mockMvc.perform(post("/endpoint").principal(myFakeUser));
```

However it seems that the method is ignored if the principal is set using a custom servlet filter, like in our case (see `TokenFilter` registration defined in `VospaceApplication` class).

To bypass the problem a fake `TokenFilter` has been defined in `TokenFilterConfig` test class. This filter returns some fake users based on the received fake token. If you need additional test users just add them in the `getFakeUser()` method.

To use the fake filter add the following annotations to the test class:

```java
@ContextConfiguration(classes = {TokenFilterConfig.class})
@TestPropertySource(properties = "spring.main.allow-bean-definition-overriding=true")
```

Then add the fake token to the test request:

```java
mockMvc.perform(post("/endpoint").header("Authorization", "Bearer user1_token"));
```
