package it.inaf.oats.vospace;


import it.inaf.ia2.aa.data.User;
import it.inaf.oats.vospace.datamodel.NodeUtils;
import it.inaf.oats.vospace.exception.LinkFoundException;
import it.inaf.oats.vospace.exception.NodeNotFoundException;
import it.inaf.oats.vospace.exception.PermissionDeniedException;
import it.inaf.oats.vospace.persistence.NodeDAO;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import net.ivoa.xml.vospace.v2.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class SetNodeController extends BaseNodeController {
    
    private static final Logger LOG = LoggerFactory.getLogger(SetNodeController.class);

    @Autowired
    private NodeDAO nodeDao;

    @Value("${vospace-authority}")
    private String authority;

    @PostMapping(value = {"/nodes", "/nodes/**"},
            consumes = {MediaType.APPLICATION_XML_VALUE, MediaType.TEXT_XML_VALUE, MediaType.APPLICATION_JSON_VALUE},
            produces = {MediaType.APPLICATION_XML_VALUE, MediaType.TEXT_XML_VALUE, MediaType.APPLICATION_JSON_VALUE})
    public ResponseEntity<Node> setNode(@RequestBody Node node, User principal, HttpServletRequest request) {

        String path = getPath();
        LOG.debug("setNode called for path {}", path);
        
        //The service SHALL throw a HTTP 404 status code including a NodeNotFound 
        //fault in the entity-body if the target Node does not exist
        Node toBeModifiedNode = nodeDao.listNode(path)
                        .orElseThrow(() -> new NodeNotFoundException(path));
        
                    
        // The service SHALL throw a HTTP 403 status code including a PermissionDenied fault 
        // in the entity-body if the user does not have permissions to perform the operation
        if(!NodeUtils.checkIfWritable(toBeModifiedNode, principal.getName(), principal.getGroups())) {
            throw new PermissionDeniedException(path);
        }
        
        // The service SHALL throw a HTTP 403 status code including a PermissionDenied fault 
        // in the entity-body if the request attempts to modify a read-only Property.
        // This method cannot be used to modify the Node type.
        String storedNodeType = toBeModifiedNode.getType();
        String newNodeType = node.getType();
        if(!storedNodeType.equals(newNodeType)) {
            LOG.debug("setNode trying to modify type. Stored ", storedNodeType + ", requested " + newNodeType);
           throw new PermissionDeniedException(path); 
        }
                
        Node result = nodeDao.setNode(node).orElseThrow(() -> new PermissionDeniedException(""));
     
        return ResponseEntity.ok(result);
    }    
    
}
