package it.inaf.oats.vospace.persistence;

import it.inaf.oats.vospace.persistence.model.Location;
import java.util.Optional;
import javax.sql.DataSource;
import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertTrue;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(SpringExtension.class)
@ContextConfiguration(classes = {DataSourceConfig.class})
@TestPropertySource(locations = "classpath:test.properties")
public class LocationDAOTest {

    @Autowired
    private DataSource dataSource;
    private LocationDAO dao;

    @BeforeEach
    public void init() {
        dao = new LocationDAO(dataSource);
    }

    @Test
    public void testGetPortalLocation() {

        String hostname = "archive.lbto.org";

        Optional<Location> optLocation = dao.findPortalLocation(hostname);
        assertTrue(optLocation.isPresent());

        Location location = optLocation.get();

        assertEquals(hostname, location.getSource().getHostname());
    }

    @Test
    public void testInexistentLocation() {
        assertTrue(dao.findPortalLocation("foo").isEmpty());
    }

    @Test
    public void testGetRootLocation() {
        dao.getNodeLocation("/");
    }
}
