package it.inaf.oats.vospace;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import net.ivoa.xml.vospace.v2.Property;
import net.ivoa.xml.vospace.v2.UnstructuredDataNode;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import static org.mockito.ArgumentMatchers.argThat;
import static org.mockito.ArgumentMatchers.eq;
import org.mockito.InjectMocks;
import static org.mockito.Mockito.verify;
import org.mockito.Spy;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.http.MediaType;
import org.springframework.test.web.servlet.MockMvc;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.post;
import static org.springframework.test.web.servlet.result.MockMvcResultHandlers.print;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.junit.jupiter.api.Disabled;

@ExtendWith(MockitoExtension.class)
public class CreateNodeControllerTest {

    @InjectMocks
    @Spy
    private CreateNodeController controller;

    private MockMvc mockMvc;

    @BeforeEach
    public void init() {
        mockMvc = MockMvcBuilders.standaloneSetup(controller).build();
    }

    @Test
    @Disabled
    public void testFromJsonToXml() throws Exception {
        String requestBody = getResourceFileContent("create-unstructured-data-node.json");

        mockMvc.perform(post("/mypath")
                .content(requestBody)
                .contentType(MediaType.APPLICATION_JSON)
                .accept(MediaType.APPLICATION_XML))
                .andDo(print())
                .andExpect(status().isOk());

        verifyArguments();
    }

    @Test
    @Disabled
    public void testFromXmlToJson() throws Exception {
        String requestBody = getResourceFileContent("create-unstructured-data-node.xml");

        mockMvc.perform(post("/mypath")
                .content(requestBody)
                .contentType(MediaType.APPLICATION_XML)
                .accept(MediaType.APPLICATION_JSON))
                .andDo(print())
                .andExpect(status().isOk());

        verifyArguments();
    }

    @Test
    @Disabled
    public void testFromXmlToXml() throws Exception {
        String requestBody = getResourceFileContent("create-unstructured-data-node.xml");

        mockMvc.perform(post("/mypath")
                .content(requestBody)
                .contentType(MediaType.APPLICATION_XML)
                .accept(MediaType.APPLICATION_XML))
                .andDo(print())
                .andExpect(status().isOk());

        verifyArguments();
    }

    @Test
    @Disabled
    public void testFromJsonToJson() throws Exception {
        String requestBody = getResourceFileContent("create-unstructured-data-node.json");

        mockMvc.perform(post("/mypath")
                .content(requestBody)
                .contentType(MediaType.APPLICATION_JSON)
                .accept(MediaType.APPLICATION_JSON))
                .andDo(print())
                .andExpect(status().isOk());

        verifyArguments();
    }

    private void verifyArguments() {
        verify(controller).createNode(eq("mypath"),
                argThat(node -> {
                    UnstructuredDataNode udn = (UnstructuredDataNode) node;
                    Property property = udn.getProperties().getProperty().get(0);
                    return "vos:UnstructuredDataNode".equals(udn.getType())
                            && "test value".equals(property.getValue())
                            && "ivo://ivoa.net/vospace/core#description".equals(property.getUri());
                }));
    }

    protected static String getResourceFileContent(String fileName) throws Exception {
        try ( InputStream in = CreateNodeControllerTest.class.getClassLoader().getResourceAsStream(fileName)) {
            return new String(in.readAllBytes(), StandardCharsets.UTF_8);
        }
    }
}
