package it.inaf.oats.vospace.persistence;

import javax.sql.DataSource;
import net.ivoa.xml.vospace.v2.ContainerNode;
import static org.junit.jupiter.api.Assertions.assertEquals;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(SpringExtension.class)
@ContextConfiguration(classes = {DataSourceConfig.class})
@TestPropertySource(locations = "classpath:test.properties")
public class NodeDAOTest {

    @Autowired
    private DataSource dataSource;
    private NodeDAO dao;

    @BeforeEach
    public void init() {
        dao = new NodeDAO(dataSource);
    }

    @Test
    public void testListNode() {
        ContainerNode root = (ContainerNode) dao.listNode("/");
        assertEquals(4, root.getNodes().size());
    }
}
