/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package it.inaf.oats.vospace;

import it.inaf.ia2.aa.data.User;
import it.inaf.oats.vospace.datamodel.NodeProperties;
import it.inaf.oats.vospace.datamodel.NodeUtils;
import it.inaf.oats.vospace.exception.ContainerNotFoundException;
import it.inaf.oats.vospace.exception.InternalFaultException;
import it.inaf.oats.vospace.exception.LinkFoundException;
import it.inaf.oats.vospace.exception.NodeNotFoundException;
import it.inaf.oats.vospace.exception.PermissionDeniedException;
import it.inaf.oats.vospace.persistence.NodeDAO;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import net.ivoa.xml.vospace.v2.Node;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;


@RestController
public class DeleteNodeController extends BaseNodeController  {
    
    @Autowired
    private NodeDAO nodeDAO;

    @GetMapping(value = {"/nodes", "/nodes/**"},
            consumes = {MediaType.APPLICATION_XML_VALUE, MediaType.TEXT_XML_VALUE, MediaType.APPLICATION_JSON_VALUE},
            produces = {MediaType.APPLICATION_XML_VALUE, MediaType.TEXT_XML_VALUE, MediaType.APPLICATION_JSON_VALUE})
    public ResponseEntity<Node> deleteNode(HttpServletRequest request, User principal) {
        
        String path = getPath();
        
        // Check if the node is present, 
        // if the node does not exist the service SHALL throw a HTTP 404 status code 
        // including a NodeNotFound fault in the entity-body 
        // If note present, got it
        Node toBeDeletedNode = nodeDAO.listNode(path)
                        .orElseThrow(() -> new NodeNotFoundException(path));               
        
        // If a parent node in the URI path is a LinkNode, the service SHALL throw 
        // a HTTP 400 status code including a LinkFound fault in the entity-body.
        // For example, given the URI path /a/b/c, the service must throw a HTTP 400 
        // status code including a LinkFound fault in the entity-body if either /a 
        // or /a/b are LinkNodes.
        List<String> pathComponents = NodeUtils.subPathComponents(path);
        if (pathComponents.size() == 0) { 
            
            // Manage root node
            throw new PermissionDeniedException("root");
            
        } else {
            
            // Manage all precursors in full path
            for (int i = 1; i < pathComponents.size(); i++) { 
                String tmpPath = pathComponents.get(i);
                Node mynode = nodeDAO.listNode(tmpPath)
                        .orElseThrow(() -> new NodeNotFoundException(tmpPath));
                if (mynode.getType().equals("vos:LinkNode") && i < pathComponents.size()-1) // a LinkNode leaf can be deleted
                    throw new LinkFoundException(tmpPath);
                            
            }
                    
        }
        
        // DUPLICATED code from CreateNodeController - BEGIN
        List<String> nodeOwner
                = NodeProperties.getNodePropertyByURI(toBeDeletedNode, NodeProperties.CREATOR_URI);
                //= getNodePropertyByURI(
                //        toBeDeletedNode, "ivo://ivoa.net/vospace/core#creator");
        
        
        if (nodeOwner == null
                || nodeOwner.isEmpty()
                || !nodeOwner.get(0).equals(principal.getName())) {
            // Node owner check has failed: let's check if user can write
            // due to group privileges

            List<String> userGroups = principal.getGroups();

            // If the user doesn't belong to any groups throw exception
            if (userGroups == null || userGroups.isEmpty()) {
                throw new PermissionDeniedException(path);
            }

            List<String> groupWritePropValues
                    = NodeProperties.getNodePropertyByURI(toBeDeletedNode,
                            NodeProperties.CREATOR_URI);

            // If groupwrite property is absent in Parent Node throw exception
            if (groupWritePropValues == null
                    || groupWritePropValues.isEmpty()) {
                throw new PermissionDeniedException(path);
            }

            List<String> nodeGroups
                    = NodeProperties.parsePropertyStringToList(groupWritePropValues.get(0));

            if (nodeGroups.isEmpty()
                    || !nodeGroups.stream()
                            .anyMatch((i) -> userGroups.contains(i))) {
                throw new PermissionDeniedException(path);
            }

        }

        // DUPLICATED code from CreateNodeController - END
        
        
        return ResponseEntity.ok(toBeDeletedNode);
        //return toBeDeletedNode;
        //return ResponseEntity.ok(nodeDAO.deleteNode(path)
        //        .orElseThrow(() -> new InternalFaultException(path)));
        
    }
    
}


    
    

