package it.inaf.oats.vospace;

import it.inaf.oats.vospace.datamodel.NodeUtils;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseNodeController {

    @Autowired
    private HttpServletRequest servletRequest;

    
    protected String getPath() {
        
        String requestURL = servletRequest.getRequestURL().toString();
        
        return NodeUtils.getPathFromRequestURLString(requestURL);
        
    }
    
    

    protected String getParentPath(String path) {

        return NodeUtils.getParentPath(path);
    }
    
}
