package it.inaf.oats.vospace;

import it.inaf.ia2.aa.ServletRapClient;
import it.inaf.ia2.aa.data.User;
import it.inaf.ia2.rap.client.call.TokenExchangeRequest;
import it.inaf.oats.vospace.datamodel.NodeProperties;
import it.inaf.oats.vospace.persistence.NodeDAO;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import net.ivoa.xml.uws.v1.JobSummary;
import net.ivoa.xml.uws.v1.ResultReference;
import net.ivoa.xml.vospace.v2.Node;
import net.ivoa.xml.vospace.v2.Protocol;
import net.ivoa.xml.vospace.v2.Transfer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UriService {

    @Value("${vospace-authority}")
    private String authority;

    @Value("${file-service-url}")
    private String fileServiceUrl;

    @Autowired
    private NodeDAO nodeDao;

    @Autowired
    private HttpServletRequest servletRequest;

    @Autowired
    private ServletRapClient rapClient;

    public void setTransferJobResult(JobSummary job) {

        List<ResultReference> results = new ArrayList<>();

        ResultReference result = new ResultReference();
        result.setHref(getEndpoint(job));
        results.add(result);

        job.setResults(results);
    }

    public void setSyncTransferEndpoints(JobSummary job) {

        Transfer transfer = getTransfer(job);

        Protocol protocol = transfer.getProtocols().get(0);

        if (!"ivo://ivoa.net/vospace/core#httpget".equals(protocol.getUri())
                && !"ivo://ivoa.net/vospace/core#httpput".equals(protocol.getUri())) {
            throw new IllegalStateException("Unsupported protocol " + protocol.getUri());
        }
        protocol.setEndpoint(getEndpoint(job));
    }

    private String getEndpoint(JobSummary job) {

        Transfer transfer = getTransfer(job);

        String relativePath = transfer.getTarget().substring("vos://".length() + authority.length());

        // TODO handle node not found
        Node node = nodeDao.listNode(relativePath).get();

        // TODO build the path according to node type
        //
        // TODO add token for authenticated access
        String endpoint = fileServiceUrl + relativePath + "?jobId=" + job.getJobId();

        if (!"true".equals(NodeProperties.getNodePropertiesListByURI(node, NodeProperties.PUBLIC_READ_URI))) {
            endpoint += "&token=" + getEndpointToken(fileServiceUrl + relativePath);
        }

        return endpoint;
    }

    private String getEndpointToken(String endpoint) {

        String token = ((User) servletRequest.getUserPrincipal()).getAccessToken();

        if (token == null) {
            // TODO: use PermissionDenied VoSpaceException
            throw new IllegalStateException("Token is null");
        }

        TokenExchangeRequest exchangeRequest = new TokenExchangeRequest()
                .setSubjectToken(token)
                .setResource(endpoint);

        // TODO: add audience and scope
        return rapClient.exchangeToken(exchangeRequest, servletRequest);
    }

    private Transfer getTransfer(JobSummary job) {
        // TODO add checks on data type
        return (Transfer) job.getJobInfo().getAny().get(0);
    }
}
