package it.inaf.oats.vospace.persistence;

import javax.sql.DataSource;
import net.ivoa.xml.uws.v1.ExecutionPhase;
import net.ivoa.xml.uws.v1.JobSummary;
import net.ivoa.xml.vospace.v2.Transfer;
import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertTrue;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(SpringExtension.class)
@ContextConfiguration(classes = {DataSourceConfig.class})
@TestPropertySource(locations = "classpath:test.properties")
public class JobDAOTest {

    @Autowired
    private DataSource dataSource;
    private JobDAO dao;

    @BeforeEach
    public void init() {
        dao = new JobDAO(dataSource);
    }

    @Test
    public void testJob() {

        Transfer transfer = new Transfer();
        transfer.setDirection("pushToVoSpace");
        transfer.setTarget("vos://example.com!vospace/mynode");

        JobSummary job = new JobSummary();
        job.setJobId("123");
        job.setOwnerId("owner");
        job.setPhase(ExecutionPhase.PENDING);
        JobSummary.JobInfo jobInfo = new JobSummary.JobInfo();
        jobInfo.getAny().add(transfer);
        job.setJobInfo(jobInfo);

        dao.createJob(job);

        assertTrue(dao.getJob("123").isPresent());
        assertEquals(ExecutionPhase.PENDING, dao.getJob("123").get().getPhase());

        job.setPhase(ExecutionPhase.EXECUTING);
        dao.updateJob(job);

        assertEquals(ExecutionPhase.EXECUTING, dao.getJob("123").get().getPhase());
    }
}
