package it.inaf.oats.vospace.exception;

import net.ivoa.xml.uws.v1.ErrorSummaryFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ResponseStatus;

@ResponseStatus(value = HttpStatus.FORBIDDEN)
public class PermissionDeniedException extends VoSpaceErrorSummarizableException {

    public PermissionDeniedException(String path) {
        super("Permission Denied at path: " + path,
                ErrorSummaryFactory.VOSpaceFault.PERMISSION_DENIED);
    }
}
