package it.inaf.oats.vospace;

import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseNodeController {

    @Autowired
    private HttpServletRequest servletRequest;

    /**
     * Slash is a special character in defining REST endpoints and trying to
     * define a PathVariable containing slashes doesn't work, so the endpoint
     * has been defined using "/nodes/**" instead of "/nodes/{path}" and the
     * path is extracted manually parsing the request URL.
     */
    protected String getPath() {
        String requestURL = servletRequest.getRequestURL().toString();
        String[] split = requestURL.split("/nodes/");

        String path = "/";
        if (split.length == 2) {
            path += split[1];
        }
        return path;
    }
}
