package it.inaf.oats.vospace;

import it.inaf.ia2.aa.data.User;
import net.ivoa.xml.vospace.v2.Node;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.beans.factory.annotation.Autowired;
import it.inaf.oats.vospace.persistence.NodeDAO;
import java.util.List;
import org.springframework.web.bind.annotation.PutMapping;

@RestController
public class CreateNodeController extends BaseNodeController {

    @Autowired
    private NodeDAO nodeDao;

    @PutMapping(value = {"/nodes", "/nodes/**"},
            consumes = {MediaType.APPLICATION_XML_VALUE, MediaType.APPLICATION_JSON_VALUE},
            produces = {MediaType.APPLICATION_XML_VALUE, MediaType.APPLICATION_JSON_VALUE})
    public Node createNode(@RequestBody Node node, User principal) {

        String path = getPath();

        List<String> userGroups = principal.getGroups();

        nodeDao.createNode(node);
        return node;
    }
}
