package it.inaf.oats.vospace;

import it.inaf.oats.vospace.exception.NodeNotFoundException;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.http.ResponseEntity;

import net.ivoa.xml.vospace.v2.Node;

import it.inaf.oats.vospace.persistence.NodeDAO;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.MediaType;

@RestController
public class ListNodeController extends BaseNodeController {

    @Autowired
    private NodeDAO nodeDAO;

    @GetMapping(value = {"/nodes", "/nodes/**"},
            produces = {MediaType.APPLICATION_XML_VALUE, MediaType.APPLICATION_JSON_VALUE, MediaType.TEXT_XML_VALUE})
    public ResponseEntity<Node> listNode(HttpServletRequest request) {
        String path = getPath();
        return ResponseEntity.ok(nodeDAO.listNode(path)
                .orElseThrow(() -> new NodeNotFoundException(path)));
    }
}
