/*
    Author: Sonia Zorba
    Email: sonia.zorba@inaf.it
*/

-- Returns the ltree path for a given os_path
CREATE OR REPLACE FUNCTION get_ltree_path(input_os_path character varying) RETURNS ltree AS $$
BEGIN
    RETURN 
    ltree_path FROM (
        SELECT node_id, string_agg(name, '/') AS os_path, first_value(path) over() ltree_path FROM (
            SELECT f1.name, f2.path, f2.node_id
            FROM Node f1 
            JOIN Node f2 ON f1.path @> f2.path
            WHERE f2.name = (string_to_array(input_os_path, '/'))[cardinality(string_to_array(input_os_path, '/'))]
            ORDER BY f2.node_id, length(f1.path::varchar) ASC
        ) AS t1 GROUP BY node_id, path
    ) AS t2 WHERE os_path = input_os_path;
END;
$$ LANGUAGE plpgsql;
