/*
    Author: Sonia Zorba
    Email: sonia.zorba@inaf.it
*/

-- Alternative way to obtain the os_path
CREATE VIEW node_os_path AS
SELECT node_id, '/' FROM Node WHERE path = ''
UNION
SELECT node_id, '/' || string_agg(name, '/') AS os_path
FROM (
    SELECT name, p.node_id
    FROM Node n
    JOIN (
        SELECT UNNEST(string_to_array(path::varchar, '.')) AS rel_id, node_id
        FROM Node
    ) AS p ON n.node_id::varchar = p.rel_id
    ORDER BY p.node_id, nlevel(n.path)
) AS j GROUP BY node_id;
