from amqp_server import AMQPServer
from job_cache import JobCache
from config import Config


class AbortJobAMQPServer(AMQPServer):
  
    def __init__(self, host, queue):
        self.type = "abort"
        config = Config("vos_ts.conf")
        self.params = config.loadSection("job_cache")
        self.jobCache = JobCache(self.params["host"], 
                                 self.params.getint("port"), 
                                 self.params.getint("db_read"))
        super(AbortJobAMQPServer, self).__init__(host, queue)      

    def execute_callback(self, requestBody):
        return 42
      
    def run(self):
        print(f"Starting AMQP server of type {self.type}...")
        super(AbortJobAMQPServer, self).run() 
