import hashlib
import os
import sys

from config import Config


class Checksum(object):

    def __init__(self):
        config = Config("vos_ts.conf")
        self.params = config.loadSection("checksum")
        self.fileBufferSize = self.params.getint("file_buffer_size")
        self.md5FileSuffix = self.params["md5_file_suffix"]

    def setFileBufferSize(fileBufferSize):
        self.fileBufferSize = fileBufferSize
        
    def fileIsValid(self, absFilePath):
        if not self.md5FileSuffix in absFilePath:
            return True
        else:
            return False
        
    def getMD5(self, absFilePath):        
        if self.fileIsValid(absFilePath):
            md5FileName = os.path.dirname(absFilePath) + self.md5FileSuffix
            md5File = open(md5FileName, "r")
            for row in md5File:
                md5sum = row.split("  ./")[0]
                fileName = row.split("  ./")[1].rstrip()
                if fileName == os.path.basename(absFilePath):
                    return md5sum
        return None

    def md5sum(self, filePath):
        md5Hash = hashlib.md5()
        with open(filePath, "rb") as f:
            for chunk in iter(lambda: f.read(self.fileBufferSize), b""):
                md5Hash.update(chunk)
        return md5Hash.hexdigest()

    def recursive(self, folderPath):
        for folder, subfolder, files in os.walk(folderPath, topdown = False):
            cwd = os.path.basename(folder)
            parent = os.path.dirname(folder)
            md5FilePath = os.path.abspath(parent) + '/' + cwd + self.md5FileSuffix
            if not os.path.exists(md5FilePath):
                if not files == []:
                    md5file = open(md5FilePath, 'w')
                    for file in files:
                        filePath = os.path.abspath(folder) + '/' + file
                        md5file.write(self.md5sum(filePath) + "  ./" + file + '\n')
                    md5file.close()
