import psycopg2
import sys

from node import Node


class DbConnector(object):

    def __init__(self, user, password, host, port, dbname):
        self.user = user
        self.password = password
        self.host = host
        self.port = port
        self.dbname = dbname

    def connect(self):
        try:
            self.conn = psycopg2.connect(user = self.user,
                                         password = self.password,
                                         host = self.host,
                                         port = self.port,
                                         database = self.dbname)
        except(Exception, psycopg2.Error) as error :
            sys.exit(f"Error while connecting to PostgreSQL: {error}")
        self.cursor = self.conn.cursor()

    def disconnect(self):
        if(self.conn):
            self.cursor.close()
            self.conn.close()

    def insertNode(self, node, parentOSPath):
        if(self.conn):
            #print(f"parentOSPath: {parentOSPath}")
            self.cursor.execute("SELECT get_ltree_path(%s)", (parentOSPath,))
            parentLtreePath = self.cursor.fetchone()[0]
            #print(f"parentLtreePath: {parentLtreePath}, type: {type(parentLtreePath)}")
            self.cursor.execute("INSERT INTO Node(parent_path, name, type, owner_id, creator_id, content_md5) VALUES (%s, %s, %s, %s, %s, %s);", 
                                (parentLtreePath, node.name, node.type, node.ownerID, node.creatorID, node.contentMD5,))
            self.conn.commit()

    def selectNode(self):
        pass

