import threading
import time

from config import Config
from job_queue import JobQueue
from store_preprocessor import StorePreprocessor


class Preprocessor(threading.Thread):

    def __init__(self):
        threading.Thread.__init__(self)
        config = Config("vos_ts.conf")
        self.params = config.loadSection("scheduling")
        self.maxPendingJobs = self.params.getint("max_pending_jobs")
        self.maxReadyJobs = self.params.getint("max_ready_jobs")
        self.pendingQueue = JobQueue("pending")
        self.readyQueue = JobQueue("ready")
        self.storePreprocessor = StorePreprocessor()

    def run(self):
        while True:
            if(self.readyQueue.len() <= self.maxReadyJobs and self.pendingQueue.len() > 0):
                jobObj = self.pendingQueue.getJob()
                self.storePreprocessor.prepare(jobObj["jobInfo"]["userName"])
                self.storePreprocessor.start()
                self.pendingQueue.moveJobTo("ready")
                print("Job MOVED:")
            time.sleep(1)

# Test
#p = Preprocessor()
#p.start()
