import time
import os

from job_handler import JobHandler
from config import Config


class TransferService(object):

    def __init__(self):
        config = Config("vos_ts.conf")
        self.params = config.loadSection("amqp")
        self.jobHandler = JobHandler(self.params["host"])

        # PullFromVOSpace
        self.jobHandler.addAMQPServer('start', 'start_job_queue')
        self.jobHandler.addAMQPServer('poll', 'poll_job_queue')
        self.jobHandler.addAMQPServer('abort', 'abort_job_queue')

        # Push
        self.jobHandler.addAMQPServer('store', 'store_job_queue')

    def run(self):
        self.jobHandler.run()

ts = TransferService()
ts.run()
time.sleep(3)
print("Transfer service is RUNNING...")