/**_____________________________________________________________________________
 *
 *                                 OATS - INAF
 *  Osservatorio Astronomico di Tireste - Istituto Nazionale di Astrofisica
 *  Astronomical Observatory of Trieste - National Institute for Astrophysics
 * ____________________________________________________________________________
 *
 * Copyright (C) 2020  Istituto Nazionale di Astrofisica
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 * _____________________________________________________________________________
 **/

/*
    VOSpace front-end
*/

CREATE EXTENSION IF NOT EXISTS ltree;

CREATE TYPE NodeType AS ENUM ('container', 'data', 'link');

CREATE TABLE Node (
    node_id           BIGSERIAL     NOT NULL,
    parent_path       LTREE         default NULL,
    name              VARCHAR       NOT NULL,
    type              NodeType      NOT NULL,
    format            VARCHAR       default NULL,
    -- format serve per distinguere unstuctured (format=NULL) da structured che hanno un formato noto
    async_trans       BOOLEAN       default NULL,
    -- async_trans serve per indicare se il nodo e` ospitato da un cold storage e deve essere necessariamente 
    -- trasferito con un trasferimento asincrono 
    busy_state        BOOLEAN       default NULL,
    owner_id          VARCHAR       default NULL,
    creator_id        VARCHAR       default NULL,
    group_read        VARCHAR[]     default NULL,
    group_write       VARCHAR[]     default NULL,
    is_public         BOOLEAN       default NULL,
    delta             BIGINT        default NULL,
    /* potrebbe essere un delta di dati trasferito durante un trasferimento asincrono.
       Dovrebbe stare sul servizio che fa il trasferimento  (es. redis) */
    content_type      VARCHAR       default NULL,
    content_encoding  VARCHAR       default NULL,
    content_length    BIGINT        default NULL,
    content_md5       TEXT          default NULL,
    created_on        TIMESTAMP     default CURRENT_TIMESTAMP,
    last_modified     TIMESTAMP     default NULL,
    -- link             TEXT          default NULL,
    accept_views      TEXT[]        default NULL,
    provide_views     TEXT[]        default NULL,
    -- serve per mappare il nome del servizio di storage da interrogare per accedere al contenuto di questo nodo 
    -- storage_id       VARCHAR,    
    protocols         TEXT[]        default NULL,
    PRIMARY KEY (node_id)
);


CREATE TABLE NodeProperty (
    node_id           BIGSERIAL,
    property_uri      VARCHAR       NOT NULL,
    property_value    VARCHAR       default NULL,
    last_modified     TIMESTAMP     default CURRENT_TIMESTAMP,
    -- support replication with a fake primary key
    -- _rep_support     BIGINT       NOT NULL PRIMARY KEY,
    foreign key (node_id) references Node (node_id)
);


CREATE TABLE DeletedNode (
    node_id           BIGSERIAL     NOT NULL,
    name              VARCHAR       NOT NULL,
    owner_id          VARCHAR       NOT NULL,
    last_modified     TIMESTAMP     default CURRENT_TIMESTAMP,
    PRIMARY KEY (node_id)
);


CREATE TABLE Users (
    rap_id            VARCHAR       NOT NULL,
    user_name         VARCHAR       NOT NULL,
    e_mail            VARCHAR       NOT NULL,
    PRIMARY KEY (rap_id)
);