import pika
import threading
import json


class AMQPServer(threading.Thread):

    def __init__(self, host, port, queue):
        threading.Thread.__init__(self)
        self.host = host
        self.port = port
        self.queue = queue        
        self.connection = pika.BlockingConnection(pika.ConnectionParameters(host = self.host, port = self.port))
        self.channel = self.connection.channel();
        self.channel.queue_declare(queue = self.queue)
        self.channel.basic_qos(prefetch_count = 1)
        threading.Thread(target = self.channel.basic_consume(queue = self.queue, on_message_callback = self.on_request))

    def on_request(self, ch, method, props, body):
        requestBody = json.loads(body)
        print(f"Request body: {json.dumps(requestBody)}")
        response = self.execute_callback(requestBody)

        ch.basic_publish(exchange = '',
                         routing_key = props.reply_to,
                         properties = pika.BasicProperties(correlation_id = props.correlation_id),
                                                           body = json.dumps(response))
        ch.basic_ack(delivery_tag = method.delivery_tag)

    def execute_callback(self, requestBody):
        """
        This method must be implemented by
        inherited classes
        """
        pass

    def run(self):
        self.channel.start_consuming()
