import psycopg2
import sys

from node import Node


class DbConnector(object):

    def __init__(self, user, password, host, port, dbname):
        self.user = user
        self.password = password
        self.host = host
        self.port = port
        self.dbname = dbname

    def connect(self):
        try:
            self.conn = psycopg2.connect(user = self.user,
                                         password = self.password,
                                         host = self.host,
                                         port = self.port,
                                         database = self.dbname)
        except(Exception, psycopg2.Error) as error :
            sys.exit(f"Error while connecting to PostgreSQL: {error}")
        self.cursor = self.conn.cursor()

    def disconnect(self):
        if self.conn:
            self.cursor.close()
            self.conn.close()

    def insertNode(self, node, parentOSPath):
        if self.conn:
            out = open("db_connector_log.txt", "a")
            #print(f"parentOSPath: {parentOSPath}")
            self.cursor.execute("SELECT path FROM Node n JOIN node_os_path o ON n.node_id = o.node_id WHERE os_path = %s;", (parentOSPath,))
            result = self.cursor.fetchall()
            for i in result:
                out.write(f"queryResult: {i}\n")
            #parentLtreePath = self.cursor.fetchone()[0]
            parentLtreePath = result[0]
            out.write(f"parentLtreePath: {parentLtreePath}\n")
            out.write(f"parentPath: {node.parentPath}\n\n")
            out.close()
            #print(f"parentLtreePath: {parentLtreePath}, type: {type(parentLtreePath)}")
            self.cursor.execute("INSERT INTO Node(parent_path, name, type, owner_id, creator_id, content_md5) VALUES (%s, %s, %s, %s, %s, %s);", 
                                (parentLtreePath, node.name, node.type, node.ownerID, node.creatorID, node.contentMD5,))
            self.conn.commit()

    def selectNode(self):
        pass

    def getRapId(self, username):
        if self.conn:
            self.cursor.execute("SELECT rap_id FROM Users WHERE user_name = %s;", (username,))
            return self.cursor.fetchone()[0]