from amqp_server import AMQPServer
from job_cache import JobCache
from config import Config


class GetJobAMQPServer(AMQPServer):
  
    def __init__(self, host, port, queue):
        self.type = "poll"
        config = Config("vos_ts.conf")
        self.params = config.loadSection("job_cache")
        self.jobCache = JobCache(self.params["host"], 
                                 self.params.getint("port"), 
                                 self.params.getint("db_read"))
        super(GetJobAMQPServer, self).__init__(host, port, queue)      

    def execute_callback(self, requestBody):
        if "jobId" in requestBody:
            redis_res = self.jobCache.get(requestBody["jobId"])
            print(f"Redis response: {redis_res}")
            return redis_res
        else:
            return 42
      
    def run(self):
        print(f"Starting AMQP server of type {self.type}...")
        super(GetJobAMQPServer, self).run() 
