import sys

from datetime import datetime as dt


class Node(object):

    def __init__(self, name, type):
        self.parentPath = None
        self.name = name
        self.type = type
        self.format = None
        self.transferType = None
        self.busyState = None
        self.ownerID = None
        self.creatorID = None
        self.groupRead = []
        self.groupWrite = []
        self.visibility = False
        self.delta = None
        self.contentType = None
        self.contentEncoding = None
        self.contentLength = None
        self.contentMD5 = None
        self.acceptViews = []
        self.provideViews = []
        self.protocols = []
        # used only in case of update
        self.lastModified = dt.now().strftime("%Y-%m-%d %H:%M:%S")

        self.types = [ "container", "data", "link" ]

    """
    Getters
    """




    """
    Setters
    """

    def setParentPath(self, parentPath):
        self.parentPath = parentPath

    def setName(self, name):
        self.name = name

    def setType(self, type):
        if type in self.types:
            self.type = type
        else:
            sys.exit(f"FATAL: Invalid type {type}")

    def setFormat(self, format):
        self.format = format

    # 'asyncTrans' flag
    def setTransferType(self, transferType):
        self.transferType = transferType

    def setBusyState(self, busyState):
        self.busyState = busyState

    def setOwnerID(self, ownerID):
        self.ownerID = ownerID

    def setCreatorID(self, creatorID):
        self.creatorID = creatorID

    def setGroupRead(self, groupRead):
        self.groupRead = groupRead

    def setGroupWrite(self, groupWrite):
        self.groupWrite = groupWrite

    # 'isPubilc' flag
    def setVisibility(self, visibility):
        self.visibility = visibility

    def setContentType(self, contentType):
        self.contentType = contentType

    def setContendEncoding(self, contentEncoding):
        self.contentEncoding = contentEncoding

    def setContentLength(self, contentLength):
        self.contentLength = contentLength

    def setContentMD5(self, contentMD5):
        self.contentMD5 = contentMD5
