import time

from multiprocessing import Process

from config import Config
from job_queue import JobQueue


class Preprocessor(Process):

    def __init__(self):
        config = Config("vos_ts.conf")
        self.params = config.loadSection("scheduling")
        self.maxPendingJobs = self.params.getint("max_pending_jobs")
        self.maxReadyJobs = self.params.getint("max_ready_jobs")
        self.execWaitTime = self.params.getint("exec_wait_time")
        self.pendingQueue = JobQueue("pending")
        self.readyQueue = JobQueue("ready")
        super(Preprocessor, self).__init__()
        
    def wait(self):
        time.sleep(self.execWaitTime)

    def run(self):
        """
        This method must be implemented by
        inherited classes
        """
        pass