import time
import os

from job_handler import JobHandler
from store_preprocessor import StorePreprocessor
from config import Config


class TransferService(object):

    def __init__(self):
        config = Config("vos_ts.conf")
        self.params = config.loadSection("amqp")
        self.jobHandler = JobHandler(self.params["host"], self.params.getint("port"))
        self.storePreprocessor = StorePreprocessor()

        # PullFromVOSpace (via REST API)
        self.jobHandler.addAMQPServer('start', 'start_job_queue')
        self.jobHandler.addAMQPServer('poll', 'poll_job_queue')
        self.jobHandler.addAMQPServer('abort', 'abort_job_queue')

        # PushToVOSpace (via dataArchiver, the 'unofficial' command line client)
        self.jobHandler.addAMQPServer('store', 'store_job_queue')        

    def start(self):
        self.storePreprocessor.start()
        self.jobHandler.start()

ts = TransferService()
ts.start()
print("Transfer service is RUNNING...")