#!/usr/bin/env python
#
# This file is part of vospace-transfer-service
# Copyright (C) 2021 Istituto Nazionale di Astrofisica
# SPDX-License-Identifier: GPL-3.0-or-later
#

import os
import redis
import time

from multiprocessing import Process
from redis.exceptions import ConnectionError

from config import Config


class LogListener(Process):

    def __init__(self):
        config = Config("/etc/vos_ts/vos_ts.conf")
        params = config.loadSection("cache")
        self.redisCli = redis.Redis(host = params["host"],
                                    port = params["port"],
                                    db = params["db_sched"])
        params = config.loadSection("logging")
        logDir = params["log_dir"]
        logFile = params["log_file"]
        self.logQueue = params["log_queue"]
        self.logFilePath = os.path.join(logDir, logFile)
        super(LogListener, self).__init__()

    def run(self):
        if os.path.exists(self.logFilePath):
            os.remove(self.logFilePath)
        while True:
            time.sleep(0.2)
            try:
                lfp = open(self.logFilePath, 'a')
            except IOError:
                raise
            else:
                try:
                    logRecord = self.redisCli.brpop(self.logQueue)[1].decode("utf-8")
                except ConnectionError:
                    time.sleep(2)
                except Exception:
                    raise
                else:
                    lfp.write(logRecord + '\n')
                lfp.close()
